﻿using System;
using HIPS.HpiiSchemas;
using HIPS.Web.Components.Common;
using HIPS.Web.UI.ViewModels.HpiiSearch;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace HIPS.Web.UI.Conversion.HpiiSearch
{
    public static class SearchByDemographicsViewModelExtensions
    {
        public static HpiiDemographicQuery ToDemographicQuery(this SearchByDemographicsViewModel viewModel)
        {
            return new HpiiDemographicQuery
            {
                HpioNumber = viewModel.Hpio,
                FamilyName = viewModel.FamilyName,
                GivenName = !String.IsNullOrEmpty(viewModel.GivenNames) ? viewModel.GivenNames.Split(' ') : new string[0],
                DateofBirth = viewModel.DateOfBirth,
                Sex = EnumExtensions.TryParse<SexType>(viewModel.SexCode),
                AustralianAddress = viewModel.AustralianAddress.ToAustralianAddress(),
                InternationalAddress = viewModel.InternationalAddress.ToInternationalAddress()
            };
        }
    }
}